const pool = require("../config/db.js");

// Get all education types
module.exports.getEducationTypes = async (req, res) => {
  let connection;
  try {
    connection = await pool.getConnection();
    
    const [educationTypes] = await connection.query(
      "SELECT * FROM education_type ORDER BY name ASC"
    );

    return res.status(200).json({
      status: 200,
      education_types: educationTypes
    });
  } catch (error) {
    console.error("Error fetching education types:", error);
    return res.status(500).json({ 
      status: 500, 
      error: { msg: "Internal server error" } 
    });
  } finally {
    if (connection) connection.release();
  }
}; 