const pool = require("../config/db.js");
const fs = require("fs");
const path = require("path");
const env = require("../global.js");
// Dropdown Api
module.exports.getAllTeachersDropdown1 = async (req, res) => {
  try {
    // const {
    //     sectionName
    // } = req.body

    // const sessionNameExistsQuery = `SELECT * FROM teachers WHERE status = 'Active'`;
    const sessionNameExistsQuery = `SELECT * 
         FROM teachers t
         LEFT JOIN cts_detail c ON t.teacher_id = c.teacher_id
         WHERE t.status = 'Active' AND c.teacher_id IS NULL;
         `;

    const con = await pool.getConnection();

    try {
      con.query(sessionNameExistsQuery, (err, result) => {
        if (err) {
          console.log(err);
          return res.status(500).json({
            status: 500,
            error: {
              msg: "Internal server error",
            },
          });
        } else {
          return res.status(200).json({
            status: 200,
            result: {
              records: result,
            },
          });
        }
      });

      // If the class doesn't exist, you can proceed with further operations
    } catch (error) {
      return res.status(500).json({
        error: {
          msg: "Internal server error",
        },
      });
    }
  } catch {}
};

module.exports.getAllTeachersDropdown = async (req, res) => {
  try {
    const con = await pool.getConnection();

    try {
      const sessionNameExistsQuery = `
                SELECT * 
                FROM teachers t
                LEFT JOIN cts_detail c ON t.id = c.teacher_id
                WHERE t.status = 'Active' AND c.teacher_id IS NULL;
            `;

      const [result] = await con.query(sessionNameExistsQuery);
      return res.status(200).json({
        status: 200,
        result: { records: result },
      });
    } catch (error) {
      console.error("Error executing query:", error);
      return res
        .status(500)
        .json({ status: 500, error: { msg: "Internal server error" } });
    } finally {
      con.release();
    }
  } catch (error) {
    console.error("Internal server error:", error);
    return res
      .status(500)
      .json({ status: 500, error: { msg: "Internal server error" } });
  }
};

// module.exports.getAllTeachers = async (req, res) => {
//     try {
//         const get_all_teacher_query = `
//             SELECT *
//             FROM teachers
//         `;

//         const con = await pool.getConnection();

//         const results = await connection.query(get_all_teacher_query);
//         return res.status(200).json({
//             status: 200,
//             data: results,
//             message: "Fee created successfully"
//         });
//     } catch (error) {
//         console.error("Internal server error:", error);
//         return res.status(500).json({
//             status: 500,
//             error: {
//                 msg: "Internal server error"
//             }
//         });
//     }
// };

module.exports.getAllTeachers = async (req, res) => {
  try {
    const { first_name, page_number, page_size } = req.body;
    const offset = (page_number - 1) * page_size;

    const get_pagination_teachers_query = `
            SELECT * FROM teachers where first_name	like '%${first_name}%' LIMIT ? OFFSET ?
        `;
    const get_count_teacher_query = `
            SELECT COUNT(*) AS count FROM teachers
        `;

    // Get a connection from the pool
    const con = await pool.getConnection();

    try {
      // Execute the queries
      const [students] = await con.query(get_pagination_teachers_query, [
        parseInt(page_size),
        offset,
      ]);
      const [countResult] = await con.query(get_count_teacher_query);

      // Release the connection back to the pool
      con.release();

      // Convert number values to strings (except `id`)
      const convertedData = students.map((obj) => {
        return Object.fromEntries(
          Object.entries(obj).map(([key, value]) =>
            key === "id" || typeof value !== "number"
              ? [key, value]
              : [key, value.toString()]
          )
        );
      });

      let finalOutput = {
        count: countResult[0].count,
        teacher: {
          current_page: page_number,
          data: convertedData,
          first_page_url: "",
          from: 1,
          next_page_url: "",
          path: "",
          per_page: page_size,
          prev_page_url: null,
          to: page_size,
        },
      };

      return res.status(200).json({
        status: 200,
        count: countResult[0].count,
        data: finalOutput,
      });
    } catch (error) {
      // Release connection in case of query error
      con.release();
      console.error("Error executing query:", error);
      return res.status(500).json({ error: { msg: "Internal server error" } });
    }
  } catch (error) {
    console.error("Database connection error:", error);
    return res.status(500).json({ error: { msg: "Internal server error" } });
  }
};

module.exports.createTeacher = async (req, res) => {
  let connection;
  try {
    const {
      first_name,
      last_name,
      date_of_birth,
      registration_date,
      phone_number,
      email,
      blood_group_id,
      religion_id,
      gender_id,
      experience_in_years,
      status,
      department
    } = req.body;

    // Convert status to match ENUM values
    const statusValue = status === "true" ? "Active" : "Deactivate";

    connection = await pool.getConnection(); // Get a connection from the pool

    // Check if the teacher already exists
    const teacherExistsQuery = `SELECT * FROM teachers WHERE phone_number = ?`;
    const [existingTeacher] = await connection.query(teacherExistsQuery, [
      phone_number,
    ]);

    if (existingTeacher.length > 0) {
      return res.status(400).json({
        status: 400,
        error: { message: "A teacher with this phone already exists" },
      });
    }

    // Insert a new teacher entry
    const insertTeacherQuery = `
            INSERT INTO teachers (
                first_name, last_name, date_of_birth, registration_date, phone_number,
                email, blood_group_id, religion_id, gender_id, experience_in_years, status,
                created_at, updated_at, department
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), ?)
        `;

    await connection.query(insertTeacherQuery, [
      first_name,
      last_name,
      date_of_birth,
      registration_date,
      phone_number,
      email,
      blood_group_id,
      religion_id,
      gender_id,
      experience_in_years,
      statusValue,
      department
    ]);

    return res.status(201).json({
      status: 201,
      success: { msg: "Teacher create SuccessFully" },
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({
      status: 500,
      error: { msg: "Internal server error" },
    });
  } finally {
    if (connection) connection.release(); // Ensure the connection is always released
  }
};

module.exports.getTeacher = async (req, res) => {
  try {
    const { id } = req.body;

    if (!id) {
      return res.status(400).json({ error: { msg: "Teacher ID is required" } });
    }

    const get_teacher_by_id = `SELECT * FROM teachers WHERE id = ?`;

    // Get a connection from the pool
    const con = await pool.getConnection();

    try {
      // Execute query using parameterized input to prevent SQL injection
      const [results] = await con.query(get_teacher_by_id, [id]);

      // Release the connection back to the pool
      con.release();

      if (results.length === 0) {
        return res.status(404).json({ error: { msg: "Teacher not found" } });
      }

      // Construct full URL for profile_photo if it exists
      const teacher = results[0];
      if (teacher.profile_photo) {
        const baseUrl = env.BASE_URL || `http://localhost:${process.env.PORT || 8000}`;
        teacher.profile_photo = `${baseUrl}/uploads/${teacher.profile_photo}`;
      }

      return res.status(200).json({
        status: 200,
        data: {
          teacher: teacher,
        },
      });
    } catch (error) {
      console.error("Error executing query:", error);
      return res.status(500).json({ error: { msg: "Internal server error" } });
    } finally {
      con.release(); // Ensure connection is always released
    }
  } catch (error) {
    console.error("Database connection error:", error);
    return res.status(500).json({ error: { msg: "Internal server error" } });
  }
};

module.exports.updateTeacher = async (req, res) => {
  let connection;
  try {
    const {
      first_name,
      last_name,
      date_of_birth,
      registration_date,
      phone_number, // Assuming phone_number is the unique identifier
      email,
      blood_group_id,
      religion_id,
      gender_id,
      experience_in_years,
      status,
      place_of_birth,
      id,
      department
    } = req.body;

    // Convert status to match ENUM values
    const statusValue = status === "true" ? "Active" : "Deactivate";

    connection = await pool.getConnection(); // Get a connection from the pool

    // Check if the teacher exists
    // const teacherExistsQuery = `SELECT * FROM teachers WHERE phone_number = ?`;
    // const [existingTeacher] = await connection.query(teacherExistsQuery, [phone_number]);

    // if (existingTeacher.length === 0) {
    //     return res.status(404).json({
    //         status: 404,
    //         error: { message: "Teacher not found" }
    //     });
    // }

    // Update the teacher's information
    const updateTeacherQuery = `
            UPDATE teachers 
            SET 
                first_name = ?, 
                last_name = ?, 
                date_of_birth = ?, 
                registration_date = ?, 
                email = ?, 
                blood_group_id = ?,
                place_of_birth = ?,
                religion_id = ?, 
                gender_id = ?, 
                experience_in_years = ?, 
                status = ?, 
                department = ?,
                updated_at = NOW(),
                phone_number = ?
            WHERE id = ?
        `;

    await connection.query(updateTeacherQuery, [
      first_name,
      last_name,
      date_of_birth,
      registration_date,
      email,
      blood_group_id,
      place_of_birth,
      religion_id,
      gender_id,
      experience_in_years,
      statusValue,
      department,
      phone_number,
      id,
    ]);

    return res.status(200).json({
      status: 200,
      responseMessage: "Teacher updated successfully",
      success: { msg: "Teacher updated successfully" },
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({
      status: 500,
      error: { msg: "Internal server error" },
    });
  } finally {
    if (connection) connection.release(); // Ensure the connection is always released
  }
};

module.exports.updatePicture = async (req, res) => {
  let connection;
  try {
    const { teacher_id } = req.body;

    if (!teacher_id) {
      return res.status(400).json({ error: "Teacher ID is required" });
    }

    if (!req.file) {
      return res.status(400).json({ error: "No file uploaded" });
    }

    const profilePhoto = req.file.filename; // Get uploaded file name

    // Get a connection from the pool
    connection = await pool.getConnection();

    const query = `UPDATE teachers SET profile_photo = ? WHERE id = ?`;
    const [result] = await connection.query(query, [profilePhoto, teacher_id]);

    // Release connection back to the pool
    connection.release();

    if (result.affectedRows === 0) {
      return res.status(404).json({ error: "Teacher not found" });
    }

    console.log("Database update successful:", result);

    return res.status(200).json({
      data: {
        message: "Teacher's profile photo successfully updated!",
        teacher_id,
        profile_photo: profilePhoto,
      },
    });
  } catch (error) {
    console.error("Unexpected error:", error);
    return res
      .status(500)
      .json({ error: "Internal server error", details: error.message });
  } finally {
    if (connection) connection.release(); // Ensure the connection is always released
  }
};
module.exports.getTeacherDocument = async (req, res) => {
  try {
    const { teacher_id } = req.body;
    console.log(req.body, "req.body");
    if (!teacher_id) {
      return res.status(400).json({ error: { msg: "Teacher ID is required" } });
    }

    // Query to get all documents for the given teacher_id
    const get_documents_by_teacher_id = `
      SELECT id, field_name, file_name 
      FROM teacher_documents 
      WHERE teacher_id = ?`;

    const con = await pool.getConnection();

    try {
      const [results] = await con.query(get_documents_by_teacher_id, [
        teacher_id,
      ]);
      console.log(results, "results");
      if (results.length === 0) {
        return res
          .status(200)
          .json({ error: { msg: "No documents found for this teacher" } });
      }

      // Map the results into a more readable format
      const documents = results.map((doc) => ({
        id: doc.id,
        field_name: doc.field_name,
        file_name: doc.file_name,
      }));

      return res.status(200).json({
        status: 200,
        data: {
          teacher_id,
          documents,
        },
      });
    } catch (error) {
      console.error("Error executing query:", error);
      return res.status(500).json({ error: { msg: "Internal server error" } });
    } finally {
      con.release(); // Always release inside inner try-finally
    }
  } catch (error) {
    console.error("Database connection error:", error);
    return res.status(500).json({ error: { msg: "Internal server error" } });
  }
};
module.exports.updateDocument = async (req, res) => {
  let connection;
  try {
    const { teacher_id, id } = req.body;
    if (!teacher_id && !id) {
      return res.status(400).json({ error: "Teacher ID is required" });
    }

    if (!req.files || req.files.length === 0) {
      return res.status(400).json({ error: "At least one file is required" });
    }

    const uploadedDocs = {};
    for (const file of req.files) {
      uploadedDocs[file.fieldname] = file.filename;
    }

    if (Object.keys(uploadedDocs).length === 0) {
      return res.status(400).json({ error: "No valid documents provided" });
    }

    connection = await pool.getConnection();
    await connection.beginTransaction();

    if (id) {
      // UPDATE: Get the existing document row by ID
      const [rows] = await connection.query(
        "SELECT * FROM teacher_documents WHERE id = ?",
        [id]
      );
      const existingRecord = rows[0];
      console.log(existingRecord, "existingRecord");
      if (!existingRecord) {
        await connection.rollback();
        return res.status(200).json({ error: "Document not found for update" });
      }

      const fieldName = req.files[0].fieldname;
      const newFileName = uploadedDocs[fieldName];

      // Delete old file from disk
      await deleteFile(existingRecord.file_name);

      // Update the record
      await connection.query(
        `UPDATE teacher_documents SET file_name = ?, field_name = ? WHERE id = ?`,
        [newFileName, fieldName, id]
      );

      await connection.commit();
      return res.status(200).json({
        status: 200,
        message: "Document updated successfully",
        document_id: id,
        updated: {
          field_name: fieldName,
          file_name: newFileName,
        },
      });
    } else {
      // CREATE: Add new documents for the teacher
      for (const fieldName in uploadedDocs) {
        const fileName = uploadedDocs[fieldName];
        await connection.query(
          `INSERT INTO teacher_documents (teacher_id, field_name, file_name) VALUES (?, ?, ?)`,
          [teacher_id, fieldName, fileName]
        );
      }

      await connection.commit();
      return res.status(200).json({
        status: 200,
        message: "Teacher documents added successfully",
        teacher_id,
        documents: uploadedDocs,
      });
    }
  } catch (error) {
    if (connection) await connection.rollback();
    console.error("Error updating document:", error);
    return res.status(500).json({
      error: "Internal server error",
      details:
        process.env.NODE_ENV === "development" ? error.message : undefined,
    });
  } finally {
    if (connection) await connection.release();
  }
};

module.exports.removeDocument = async (req, res) => {
  let connection;
  try {
    const { id, document_name } = req.body;
    console.log(req.body, "req.body");
    if (!id || !document_name) {
      return res.status(400).json({
        error:
          "Both 'id' (document ID) and 'document_name' (field_name) are required",
      });
    }
    console.log("id", id);

    // Get DB connection
    connection = await pool.getConnection();
    await connection.beginTransaction();

    // Fetch the document based on ID and field_name
    const [rows] = await connection.query(
      "SELECT * FROM teacher_documents WHERE id = ? AND field_name = ?",
      [id, document_name]
    );

    if (rows.length === 0) {
      return res.status(200).json({ error: "Document not found" });
    }

    const documentToDelete = rows[0];

    // Delete the file from server
    await deleteFile(documentToDelete.file_name);

    // Remove the document from the database
    await connection.query(
      "DELETE FROM teacher_documents WHERE id = ? AND field_name = ?",
      [id, document_name]
    );

    await connection.commit();
    return res.status(200).json({
      status: 200,
      message: "Document removed successfully",
    });
  } catch (error) {
    if (connection) await connection.rollback();
    console.error("Error removing document:", error);
    return res.status(500).json({
      error: "Internal server error",
      details:
        process.env.NODE_ENV === "development" ? error.message : undefined,
    });
  } finally {
    if (connection) await connection.release();
  }
};

const deleteFile = (filename) => {
  const filePath = path.join(__dirname, "./../", "public", "uploads", filename);
  console.log("filePath", filePath);
  console.log("filepath is: ", filePath);
  // Use fs.unlink() to delete the file
  fs.unlink(filePath, (err) => {
    if (err) {
      console.error("Error deleting the file:", err);
      return 0;
    } else {
      console.log("this is in else ");
      return 1;
    }

    // console.log('File deleted successfully');
  });
};
