const express = require('express');
const router = express.Router();
const educationTypeController = require('../controllers/educationTypeController');
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

router.use(authenticateToken);

// Get all education types
router.get('/all', hasPermission('view_education_types'), educationTypeController.getEducationTypes);

module.exports = router; 