const express = require("express");
const batchRouter = express.Router();
const {
  createBatch,
  getBatchById,
  getAllBatches,
  updateBatch,
  deleteBatch
} = require("../controllers/batchController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

batchRouter.use(authenticateToken);

batchRouter.post("/create", hasPermission('create_batch'), createBatch);
batchRouter.post("/get", hasPermission('view_batches'), getBatchById);
batchRouter.post("/all", hasPermission('view_batches'), getAllBatches);
batchRouter.post("/update", hasPermission('update_batch'), updateBatch);
batchRouter.post("/delete", hasPermission('delete_batch'), deleteBatch);

module.exports = batchRouter; 