const express = require("express");
const batchStudentRouter = express.Router();
const {
  createBatchStudent,
  getBatchStudentById,
  getAllBatchStudents,
  updateBatchStudent,
  deleteBatchStudent,
  getStudentsByBatchId,
  getBatchStudentStatusHistory,
  getAllClassSection,
  getStudentAcademicHistory,
  loadAttendance,
  updateAttendance
} = require("../controllers/batchStudentController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

batchStudentRouter.use(authenticateToken);
batchStudentRouter.post("/create", hasPermission('create_batch_student'), createBatchStudent);
batchStudentRouter.post("/get", hasPermission('view_batch_students'), getBatchStudentById);
batchStudentRouter.post("/all", hasPermission('view_batch_students'), getAllBatchStudents);
batchStudentRouter.post("/update", hasPermission('update_batch_student'), updateBatchStudent);
batchStudentRouter.post("/delete", hasPermission('delete_batch_student'), deleteBatchStudent);
batchStudentRouter.post("/list-students-in-batch", hasPermission('view_batch_students'), getStudentsByBatchId);
batchStudentRouter.post("/status-history", hasPermission('view_batch_students'), getBatchStudentStatusHistory);
batchStudentRouter.post("/class-section", hasPermission('view_batch_students'), getAllClassSection);
batchStudentRouter.get("/students/:student_id/history", hasPermission('view_batch_students'), getStudentAcademicHistory);
batchStudentRouter.post("/attendance", loadAttendance);
batchStudentRouter.post("/attendance/update", updateAttendance);
module.exports = batchStudentRouter; 