const express = require("express");
const classRouter = express.Router();
const { createClass, deleteClass, getAllClass, getClassById, updateClass, createClassSection, getAllClassSection, deleteClassSection } = require("../controllers/classesController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');


classRouter.use(authenticateToken);

classRouter.post('/createClass', hasPermission('create_class'), createClass);
classRouter.post('/updateClass', hasPermission('update_class'), updateClass);
classRouter.post('/getAll', hasPermission('view_classes'), getAllClass);
classRouter.post('/getById', hasPermission('view_classes'), getClassById);
classRouter.post('/deleteClass', hasPermission('delete_class'), deleteClass);
classRouter.post('/createClassSection', hasPermission('create_class_section'), createClassSection);
classRouter.post('/getAllClassSection', hasPermission('view_class_sections'), getAllClassSection);
classRouter.post('/deleteClassSection', hasPermission('delete_class_section'), deleteClassSection);

module.exports = classRouter;