const express = require("express");
const dashboardRouter = express.Router();
const auth = require("./../utils/auth");
const { getAnalytics } = require("../controllers/dashboardController");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');


dashboardRouter.use(authenticateToken);
dashboardRouter.get('/getAnalytics', hasPermission('view_dashboard'), getAnalytics);

module.exports = dashboardRouter;