const express = require("express");
const degreeRouter = express.Router();
const { createDegree , updateDegree, getAllDegree, getDegreeById, deleteDegree} = require("../controllers/degreeController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');


degreeRouter.use(authenticateToken);

degreeRouter.post('/createDegree', hasPermission('create_degree'), createDegree);
degreeRouter.post('/updateDegree', hasPermission('update_degree'), updateDegree);
degreeRouter.post('/getAllDegree', hasPermission('view_degrees'), getAllDegree);
degreeRouter.post('/getDegreeById', hasPermission('view_degrees'), getDegreeById);
degreeRouter.post('/deleteDegree', hasPermission('delete_degree'), deleteDegree);

module.exports = degreeRouter;