const express = require("express");
const degreeSubjectRouter = express.Router();
const {
  createDegreeSubject,
  updateDegreeSubject,
  getAllDegreeSubjects,
  getDegreeSubjectById,
  deleteDegreeSubject,
} = require("../controllers/degreeSubjectController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

degreeSubjectRouter.use(authenticateToken);
degreeSubjectRouter.post("/createDegreeSubject", hasPermission('create_degree_subject'), createDegreeSubject);
degreeSubjectRouter.post("/updateDegreeSubject", hasPermission('update_degree_subject'), updateDegreeSubject);
degreeSubjectRouter.post("/getAllDegreeSubjects", hasPermission('view_degree_subjects'), getAllDegreeSubjects);
degreeSubjectRouter.post("/getDegreeSubjectById", hasPermission('view_degree_subjects'), getDegreeSubjectById);
degreeSubjectRouter.post("/deleteDegreeSubject", hasPermission('delete_degree_subject'), deleteDegreeSubject);

module.exports = degreeSubjectRouter;
