const express = require("express");
const examRouter = express.Router();
const {
  createExam,
  getExamById,
  getAllExams,
  updateExam,
  deleteExam
} = require("../controllers/examController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

examRouter.use(authenticateToken);
examRouter.post("/create", hasPermission('create_exam'), createExam);
examRouter.post("/get", hasPermission('view_exams'), getExamById);
examRouter.post("/all", hasPermission('view_exams'), getAllExams);
examRouter.post("/update", hasPermission('update_exam'), updateExam);
examRouter.post("/delete", hasPermission('delete_exam'), deleteExam);

module.exports = examRouter;