const express = require("express");
const expenseRouter = express.Router();
const {
  createExpense,
  getExpenseById,
  getAllExpenses,
  updateExpense,
  deleteExpense,
  getAllExpenseCategories
} = require("../controllers/expenseController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

expenseRouter.use(authenticateToken);

expenseRouter.post("/create", hasPermission('create_expense'), createExpense);

expenseRouter.post("/get", hasPermission('view_expenses'), getExpenseById);

expenseRouter.post("/all", hasPermission('view_expenses'), getAllExpenses);

expenseRouter.post("/update", hasPermission('update_expense'), updateExpense);

expenseRouter.post("/delete", hasPermission('delete_expense'), deleteExpense);

expenseRouter.post("/categories/all", hasPermission('view_expenses'), getAllExpenseCategories);
module.exports = expenseRouter;