const express = require("express");
const { 
    createFeeInstallments, 
    deleteTransaction, 
    getById, 
    getPendingAmount, 
    getStudentFeeDetail, 
    getStudentsWithFees, 
    updateFeeInstallments 
} = require("../controllers/feeController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const feeRouter = express.Router();

feeRouter.use(authenticateToken);

feeRouter.post('/createFee', hasPermission('create_fee'), createFeeInstallments);
feeRouter.post('/updateFee', hasPermission('update_fee'), updateFeeInstallments);
feeRouter.post('/getFeeDetail', hasPermission('view_fees'), getStudentFeeDetail);
feeRouter.post('/getStudentsWithFees', hasPermission('view_fees'), getStudentsWithFees);
feeRouter.post('/getPendingAmount', hasPermission('view_fees'), getPendingAmount);
feeRouter.post('/getById', hasPermission('view_fees'), getById);
feeRouter.post('/deleteTransaction', hasPermission('delete_fee'), deleteTransaction);
 
// feeRouter.post('/updateFee', updateFee);
// feeRouter.post('/getAll', getAllFee);
// feeRouter.post('/getById', getFeeById);
// feeRouter.post('/deleteFee', deleteFee);

module.exports = feeRouter