const express = require("express");
const auth = require("./../utils/auth");
const upload = require("./../middlewares/upload");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const { 
    addOrUpdateGuardian,
    getGuardianByStudentId,
    getAllGuardians,
    deleteGuardianByStudentId
    
} = require("../controllers/GuardianController");

const guardianRouter = express.Router();

guardianRouter.use(authenticateToken);
guardianRouter.post('/save', hasPermission('create_guardian'), addOrUpdateGuardian);
guardianRouter.patch('/update', hasPermission('update_guardian'), addOrUpdateGuardian);
guardianRouter.post('/get', hasPermission('view_guardians'), getGuardianByStudentId);
// guardianRouter.post('/getByStudentId',auth, getGuardianByStudentId);


module.exports = guardianRouter