const express = require("express");
const auth = require("./../utils/auth");
const company_logo = require("../middlewares/company_logo");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const { 
    createOrUpdateInstitute, 
    getAllInstitutes
} = require("../controllers/instituteController");

const instituteRouter = express.Router();

instituteRouter.use(authenticateToken);

// instituteRouter.post('/save', auth, upload.single("company_logo"), createInstitute);
instituteRouter.post('/save', hasPermission('create_institute'), company_logo.single("company_logo"), createOrUpdateInstitute);
instituteRouter.post('/getAll', hasPermission('view_institutes'), getAllInstitutes);
// instituteRouter.post('/getCompanyInfo', hasPermission('view_institutes'), getAllInstitutes);

module.exports = instituteRouter