const express = require("express");
const { getBloodGroups ,getGender,getReligions,getAllRelations} = require("../controllers/miscController");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const miscRouter = express.Router();

miscRouter.use(authenticateToken);
miscRouter.post('/genders', hasPermission('view_misc'), getGender);
miscRouter.post('/blood-groups', hasPermission('view_misc'), getBloodGroups);
miscRouter.post('/religions', hasPermission('view_misc'), getReligions);
miscRouter.post('/receiver-relations', hasPermission('view_misc'), getAllRelations);


module.exports = miscRouter;
