const express = require("express");
const auth = require("./../utils/auth");
const parentPicture = require("./../middlewares/parentPicture");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');


const { 
    addParent,
    getAllParents,
    getParentById,
    updateParentById,
    updateParentPicture,
    // scanFingerprint 

} = require("../controllers/parentController");

const parentRouter = express.Router();

parentRouter.use(authenticateToken);
parentRouter.post('/store', hasPermission('create_parent'), addParent);
parentRouter.get('/get-all', hasPermission('view_parents'), getAllParents);
parentRouter.post('/get', hasPermission('view_parents'), getParentById);
parentRouter.patch('/update', hasPermission('update_parent'), updateParentById);
parentRouter.post("/parent-picture", hasPermission('update_parent'), parentPicture.single("profile_photo"), updateParentPicture);
module.exports = parentRouter;
