const express = require("express");
const auth = require("./../utils/auth");
const upload = require("./../middlewares/upload");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const {
  createReceiver,
  updateReceiver,
  getReceiverById,
  getAllReceivers,
  deleteReceiver,
} = require("../controllers/receiverController");

const receiverRouter = express.Router();

receiverRouter.use(authenticateToken);
receiverRouter.post("/store", hasPermission('create_receiver'), createReceiver);
receiverRouter.patch("/update", hasPermission('update_receiver'), updateReceiver);
receiverRouter.post("/get", hasPermission('view_receivers'), getReceiverById);
receiverRouter.post("/getAllReceiver", hasPermission('view_receivers'), getAllReceivers);
receiverRouter.post("/deleteReceiver", hasPermission('delete_receiver'), deleteReceiver);
// receiverRouter.post('/get',auth, updateReceiver);
// guardianRouter.post('/getByStudentId',auth, getGuardianByStudentId);

module.exports = receiverRouter;
