const express = require("express");
const { 
  
    createSection, 
    getAllSections, 
    updateSection,
    getSectionById,
    deleteSection,
    getSectionDropdown
   
} = require("../controllers/sectionController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const sectionRouter = express.Router();

sectionRouter.use(authenticateToken);

sectionRouter.post('/createSection', hasPermission('create_section'), createSection);
sectionRouter.post('/updateSection', hasPermission('update_section'), updateSection);
sectionRouter.post('/getAllSection', hasPermission('view_sections'), getAllSections);
sectionRouter.post('/getSectionById', hasPermission('view_sections'), getSectionById);
sectionRouter.post('/deleteSection', hasPermission('delete_section'), deleteSection);
sectionRouter.post('/getSectionDropdown', hasPermission('view_sections'), getSectionDropdown);

    

module.exports = sectionRouter;