const express = require("express");
const smesterRouter = express.Router();
const {
  createSemester,
  updateSemester,
  getAllSemesters,
  getSemesterById,
  deleteSemesters,
  getDurations,
} = require("../controllers/semesterController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

smesterRouter.use(authenticateToken);
smesterRouter.post("/createSemester", hasPermission('create_semester'), createSemester);
smesterRouter.post("/updateSemester", hasPermission('update_semester'), updateSemester);
smesterRouter.post("/getAllSemester", hasPermission('view_semesters'), getAllSemesters);
smesterRouter.post("/getSemesterById", hasPermission('view_semesters'), getSemesterById);
smesterRouter.post("/deleteSemesters", hasPermission('delete_semester'), deleteSemesters);
smesterRouter.get("/durations", hasPermission('view_semesters'), getDurations);

module.exports = smesterRouter;
