const express = require("express");
const sessionRouter = express.Router();
const {
    updateSession,
    deleteSession,
    getSessionById,
    getAllSessions,
    createSession,
    getCurrentActiveSession
}
 = require("../controllers/sessionController"); // Adjust the path if needed
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

// Routes for session management
sessionRouter.use(authenticateToken);
sessionRouter.post("/create", hasPermission('create_session'), createSession);
sessionRouter.post("/all", hasPermission('view_sessions'), getAllSessions);
sessionRouter.post("/get", hasPermission('view_sessions'), getSessionById);
sessionRouter.post("/delete", hasPermission('delete_session'), deleteSession);
sessionRouter.post("/update", hasPermission('update_session'), updateSession);
sessionRouter.get("/current-active-session", hasPermission('view_sessions'), getCurrentActiveSession);

module.exports = sessionRouter;