const express = require("express");
const auth = require("./../utils/auth");
const upload = require("./../middlewares/upload");
const {
  createStudentFee,
  getAllStudentDropdown,
  getAmountById,
  getAllStudent,
  getStudent,
  addStudent,
  updateStudent,
  updateProfilePhoto,
  updateDocument,
  getStudentDocument,
  removeDocument,
} = require("../controllers/studentController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const studentRouter = express.Router();

studentRouter.use(authenticateToken);
studentRouter.post("/createStudentFee", hasPermission('create_student_fee'), createStudentFee);
studentRouter.post("/getAmountById", hasPermission('view_students'), getAmountById);
studentRouter.post("/getStudentDropdown", hasPermission('view_students'), getAllStudentDropdown);
studentRouter.post("/get-all", hasPermission('view_students'), getAllStudent);
studentRouter.post("/get", hasPermission('view_students'), getStudent);
studentRouter.post("/store", hasPermission('create_student'), addStudent);
studentRouter.patch("/update", hasPermission('update_student'), updateStudent);
studentRouter.post("/document/store", hasPermission('update_student'), upload.any(), updateDocument);
studentRouter.post("/document/get", hasPermission('view_students'), getStudentDocument);
studentRouter.post("/document/remove", hasPermission('update_student'), removeDocument);
studentRouter.post(
  "/update-profile-photo",
  hasPermission('update_student'),
  upload.single("profile_photo"),
  updateProfilePhoto
);
module.exports = studentRouter;
