const express = require("express");
const subjectSemesterRouter = express.Router();
const { createSubjectMapping , updateSubjectMapping, getAllSubjectMappings, getSubjectMappingById, deleteSubjectMappings} = require("../controllers/subjectSemesterMappingContorller");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

subjectSemesterRouter.use(authenticateToken);
subjectSemesterRouter.post('/createSubjectMapping', hasPermission('create_subject_mapping'), createSubjectMapping);
subjectSemesterRouter.post('/updateSubjectMapping', hasPermission('update_subject_mapping'), updateSubjectMapping);
subjectSemesterRouter.post('/getAllSubjectMappings', hasPermission('view_subject_mappings'), getAllSubjectMappings);
subjectSemesterRouter.post('/getSubjectMappingById', hasPermission('view_subject_mappings'), getSubjectMappingById);
subjectSemesterRouter.post('/deleteSubjectMappings', hasPermission('delete_subject_mapping'), deleteSubjectMappings);

module.exports = subjectSemesterRouter;