const express = require("express");
const subjectRouter = express.Router();
const { createSubject , updateSubject, getAllSubjects, getSubjectById, deleteSubject} = require("../controllers/subjectController.js");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

subjectRouter.use(authenticateToken);
subjectRouter.post('/createSubject', hasPermission('create_subject'), createSubject);
subjectRouter.post('/updateSubject', hasPermission('update_subject'), updateSubject);
subjectRouter.post('/getAllSubject', hasPermission('view_subjects'), getAllSubjects);
subjectRouter.post('/getSubjectById', hasPermission('view_subjects'), getSubjectById);
subjectRouter.post('/deleteSubject', hasPermission('delete_subject'), deleteSubject);

module.exports = subjectRouter;