const express = require("express");
const auth = require("./../utils/auth");
const upload = require("./../middlewares/upload");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

const {
  getAllTeachersDropdown,
  getAllTeachers,
  createTeacher,
  getTeacher,
  updateTeacher,
  updatePicture,
  updateDocument,
  getTeacherDocument,
  removeDocument,
} = require("../controllers/teacherController.js");

const teacherRouter = express.Router();

teacherRouter.use(authenticateToken);
teacherRouter.post("/getTeacherDropdown", hasPermission('view_teachers'), getAllTeachersDropdown);
teacherRouter.post("/get-all", hasPermission('view_teachers'), getAllTeachers);
teacherRouter.post("/store", hasPermission('create_teacher'), createTeacher);
teacherRouter.post("/get", hasPermission('view_teachers'), getTeacher);
teacherRouter.patch("/update", hasPermission('update_teacher'), updateTeacher);
teacherRouter.post(
  "/update-profile-photo",
  hasPermission('update_teacher'),
  upload.single("profile_photo"),
  updatePicture
);
teacherRouter.post("/document/store", hasPermission('update_teacher'), upload.any(), updateDocument);
teacherRouter.post("/document/get", hasPermission('view_teachers'), getTeacherDocument);
teacherRouter.post("/document/remove", hasPermission('update_teacher'), removeDocument);
module.exports = teacherRouter;
