const express = require("express");
const thumbRouter = express.Router();
const auth = require("./../utils/auth");
const upload = require("../middlewares/thumb_impression"); // Middleware for handling file uploads
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');
const {
  addOrUpdateStudentThumb,
  getStudentThumbById,
  updateStudentThumbById,
  deleteThumbs,
  getAllStudentThumbs,
} = require("../controllers/thumbController");

thumbRouter.use(authenticateToken);

// ✅ Create or Update Student Thumb
thumbRouter.post("/get", hasPermission('view_thumbs'), getStudentThumbById);
thumbRouter.post("/getAllThumb", hasPermission('view_thumbs'), getAllStudentThumbs);
thumbRouter.post("/deleteThumb", hasPermission('delete_thumb'), deleteThumbs);
thumbRouter.post("/create", hasPermission('create_thumb'), addOrUpdateStudentThumb);

// ✅ Get Student Thumb by Student ID (POST instead of GET)
thumbRouter.post("/student-thumb-by-id", hasPermission('view_thumbs'), getStudentThumbById);

module.exports = thumbRouter;
