const express = require("express");
const { loginUser, addUser, getAllUsers, updateUser, deleteUser,getUserById,getAllRoles} = require("../controllers/userController.js");
const userRouter = express.Router();
const auth = require("./../utils/auth");
const { authenticateToken, hasPermission } = require('../middlewares/auth.js');

userRouter.post('/login', loginUser);
userRouter.post("/createUser", authenticateToken, hasPermission('create_user'), addUser);
userRouter.post("/getUserById", authenticateToken, hasPermission('view_users'), getUserById);
userRouter.post("/getAllUser", authenticateToken, hasPermission('view_users'), getAllUsers);
userRouter.post("/updateUser", authenticateToken, hasPermission('update_user'), updateUser);
userRouter.post("/deleteUser", authenticateToken, hasPermission('delete_user'), deleteUser);
userRouter.get("/role", authenticateToken, hasPermission('view_roles'), getAllRoles);
module.exports = userRouter;


